function test_suite = testMinus %#ok<STOUT>
initTestSuite;

function testZeros %#ok<*DEFNU>
x = polysym(0);
y = polysym(0);
z = x-y;
assertEqual(z.Value,'0');

function testOneZero
x = polysym(0);
y = polysym('y');
z = y-x;
assertEqual(z.Value,'y');

function testZeroMinusReal
x = polysym(0);
y = polysym(pi);
z = y-x;
assertEqual(z,y);

function testRealMinusChar
x = polysym('x');
y = polysym(5);
z = x-y;
assertEqual(z.Value,'x-5');

function testScalarMinusVector
x = polysym('x');
y = polysym(1:3);
z = x-y;
assertEqual(z(1).Value,'x-1');
assertEqual(z(2).Value,'x-2');
assertEqual(z(3).Value,'x-3');

function testVectorMinusVector
x = polysym({'x','y'});
y = polysym({'u','w'});
z = x-y;
assertEqual(z(1).Value,'x-u');
assertEqual(z(2).Value,'y-w');

function testAssociative1
x = polysym('x');
y = polysym('4-y');
z = x-y;
assertEqual(z.Value,'x-(4-y)');

function testAssociative2
x = polysym('x');
y = polysym('4*y');
z = x-y;
assertEqual(z.Value,'x-4*y');
